#!/bin/sh
# exp param
env="Football"
scenario="academy_pass_and_shoot_with_keeper"
algo="rmappo" # "mappo" "ippo"
exp="check"
seed=5

# football param
num_agents=2

# train param
num_env_steps=50000000
episode_length=200

echo "n_rollout_threads: ${n_rollout_threads} \t ppo_epoch: ${ppo_epoch} \t num_mini_batch: ${num_mini_batch}"

CUDA_VISIBLE_DEVICES=1 python ../train/train_football.py \
--env_name ${env} --scenario_name ${scenario} --algorithm_name ${algo} --experiment_name ${exp} --seed ${seed} \
--num_agents ${num_agents} --num_env_steps ${num_env_steps} --episode_length ${episode_length} \
--representation "simple115v2" --rewards "scoring,checkpoints" --n_rollout_threads 16 --ppo_epoch 15 --num_mini_batch 2 \
--save_interval 10000 --log_interval 1000 --use_eval --eval_interval 1000 --n_eval_rollout_threads 32 --eval_episodes 32 \
--user_name "xxx" --name "dyn_mappo"
